#include <bits/stdc++.h>
using namespace std;

#define long int64_t
#define endl '\n'

#ifdef OFFLINE
	#define logan(...) logg(#__VA_ARGS__, __VA_ARGS__)
	template<class Arg>
	void logg(const char* name, Arg&& arg){ cerr << name << ": " << arg << '\n'; }
	template<class Arg, class ... Args>
	void logg(const char* name, Arg&& arg, Args&& ... args){
		const char* next = strchr(name+1, ',');
		cerr.write(name, next-name) << ": " << arg << ",";
		logg(next+1, args...);
	}
	#define timeme 1.0*clock()/CLOCKS_PER_SEC
#else
	#define logan(...) {}
	#define timeme {}
#endif

#define ulong uint64_t

template<ulong m>
struct modint {
	ulong x;

	modint() : x(0) {}
	modint(long arg) {
		x = arg%m;
		x = (arg < 0 ? arg+m : arg);
	}

	modint& operator+= (const modint& other) {
		x += other.x;
		if (x >= m) x -= m;
		return *this;
	}

	modint& operator*= (const modint& other) {
		x = (x * other.x) % m;
		return *this;
	}

	modint& operator-= (const modint& other) {
		x += m - other.x;
		if(x >= m) x -= m;
		return *this;
	}

	modint operator+ (const modint& other) const {
		modint tmp = *this;
		tmp += other;
		return tmp;
	}

	modint operator- (const modint& other) const {
		modint tmp = *this;
		tmp -= other;
		return tmp;
	}

	modint operator* (const modint& other) const {
		modint tmp = *this;
		tmp *= other;
		return tmp;
	}

	explicit operator ulong () const { return x; }
	modint& operator++ () {
		++x;
		if(x == m) x = 0;
		return *this;
	}

	modint& operator-- () {
		if(x == 0) x = m-1;
		else --x;
		return *this;
	}

	modint operator++ (int) {
		modint tmp = *this;
		++*this;
		return tmp;
	}

	modint operator-- (int) {
		modint tmp = *this;
		--*this;
		return tmp;
	}

	bool operator== (const modint& other) const { return x == other.x; }
	bool operator!= (const modint& other) const { return x != other.x; }

	modint operator^ (ulong arg) const {
		if(arg == 0) return 1;
		if (arg == 1) return x;
		auto t = *this ^ (arg >> 1);
		t *= t;
		if (arg & 1) t *= *this;
		return t;
	}

	modint inv(ulong exp = m - 2) const {
		return *this ^ exp;
	}
	
	friend ostream& operator<< (ostream& out, const modint& x) { out << x.x; return out; }
	friend istream& operator>> (istream& in, modint& x) { in >> x.x; return in; }
};

const ulong MOD = 998244353;
typedef modint<MOD> mint;

int b[100'000];
int a[100'000];

int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	cerr.tie(nullptr);

	int n, m; cin >> n >> m;
	for(int i = 1; i <= m; ++i) cin >> b[i];
	iota(a+1, a+1+n, 1);

	for(int i = 0; i <= n-m; ++i){
		for(int j = 1; j <= m; ++j){
			a[i+b[j]] = a[i+j];
		}
	}

	long c; cin >> c;
	mint bexp = c;


	mint res = 0;
	mint exp = c;
	for(int i = 1; i <= n; ++i, exp *= bexp){
		res += exp*mint(a[i]);
	}
	cout << res << endl;
	
}